CREATE TABLE [dbo].[MEDICAL_CENTER_DIVISION]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
GO

SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[MEDICAL_CENTER_DIVISION_tgg_update]
   ON  [dbo].[MEDICAL_CENTER_DIVISION]
   AFTER UPDATE
AS 
BEGIN	
	INSERT INTO [dbo].[MEDICAL_CENTER_DIVISION_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'U',[IEN],[NAME]
        FROM inserted;
END
GO

SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[MEDICAL_CENTER_DIVISION_tgg_insert]
   ON  [dbo].[MEDICAL_CENTER_DIVISION]
   AFTER insert
AS 
BEGIN	
	INSERT INTO [dbo].[MEDICAL_CENTER_DIVISION_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'I',[IEN],[NAME]
        FROM inserted;
END
GO

SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[MEDICAL_CENTER_DIVISION_tgg_delete]
   ON  [dbo].[MEDICAL_CENTER_DIVISION]
   AFTER DELETE
AS 
BEGIN	
	INSERT INTO [dbo].[MEDICAL_CENTER_DIVISION_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'D',[IEN],[NAME]
        FROM deleted;
END
GO

ALTER TABLE [dbo].[MEDICAL_CENTER_DIVISION] ADD CONSTRAINT [PK_MEDICAL_CENTER_DIVISION] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains names of the medical center divisions.', 'SCHEMA', N'dbo', 'TABLE', N'MEDICAL_CENTER_DIVISION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the medical center division.', 'SCHEMA', N'dbo', 'TABLE', N'MEDICAL_CENTER_DIVISION', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the medical center division.', 'SCHEMA', N'dbo', 'TABLE', N'MEDICAL_CENTER_DIVISION', 'COLUMN', N'NAME'
GO
